<?php
/*
 * Plugin Name: ابزار انتقال edd به woocommerce
 * Description: تبدیل و انتقال کامل اطلاعات فروشگاه EDD به WooCommerce
 * Version: 1.0
 * Author: تم فور
 * Author URI: https://themefour.com
 * Text Domain: edd-to-woocommerce
 * Domain Path: /languages/
 *
 * Requires PHP: 7.4
 * Requires Plugins: easy-digital-downloads
 *
 * Tested up to: 6.7.1
 * WC tested up to: 9.4.1
 * WC requires at least: 8.0
 *
 * @package edd-to-woocommerce
 *
 * Copyright 2022-2024 themefour.com
 * License: themefour License v2.0
 
 
*/

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants.
define('EDD_WC_CONVERTER_VERSION', '1.0');
define('EDD_WC_CONVERTER_PATH', plugin_dir_path(__FILE__));
define('EDD_WC_CONVERTER_URL', plugin_dir_url(__FILE__));

// Include core functionality.
require_once EDD_WC_CONVERTER_PATH . 'includes/themefour-admin-settings.php';
require_once EDD_WC_CONVERTER_PATH . 'includes/themefour-transfer-handler.php';



/* START PLUGIN CORE */
/* Dir Update File Plugin */
define('TF_EDD_WC_URL', plugin_dir_url(__FILE__));
/* Dir Path Plugin */
define('TF_EDD_WC_PATH', plugin_dir_path(__FILE__));
/* Dir File Plugin */
define('TF_EDD_WC_FILE_PATH',__FILE__);
/* Dir Path Lang Plugin */
define('TF_EDD_WC_LANG', TF_EDD_WC_PATH . 'plugin-core/languages/' );
/* Dir Path ASSETS Plugin */
define('TF_EDD_WC_ASSETS', TF_EDD_WC_URL . 'plugin-core/assets/' );
/* Dir Path Class Plugin */
define('TF_EDD_WC_CLASSES', TF_EDD_WC_PATH . 'plugin-core/classes/' );
/* Dir Path Function Plugin */
define('TF_EDD_WC_FUN', TF_EDD_WC_PATH . 'plugin-core/functions/' );
/* Dir Update Path Plugin */
define('TF_EDD_WC_UPDATE_PATH', TF_EDD_WC_PATH . 'plugin-core/upgrade/' );
require_once (TF_EDD_WC_CLASSES. 'class-upgrade-edd-to-woo.php');
/* END PLUGIN CORE */